<?php

declare(strict_types=1);

namespace App\Models\Membership;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Traits\HasUuidTrait;

class PackageUserInfo extends Model
{
    use HasFactory, HasUuidTrait;

    protected $table = 'package_user_info';

    protected $fillable = [
        'uuid',
        'membership_plan_id',
        'show_website_link',
        'show_social_media_links',
        'show_phone',
        'show_address',
        'searchable',
        'show_public_review',
        'show_contact_form',
        'show_image_gallery',
        'image_gallery_limit',
        'is_featured',
        'show_video_gallery',
        'video_gallery_limit',
    ];

    protected $casts = [
        'show_website_link' => 'boolean',
        'show_social_media_links' => 'boolean',
        'show_phone' => 'boolean',
        'show_address' => 'boolean',
        'searchable' => 'boolean',
        'show_public_review' => 'boolean',
        'show_contact_form' => 'boolean',
        'show_image_gallery' => 'boolean',
        'is_featured' => 'boolean',
        'show_video_gallery' => 'boolean',
    ];

    public function membershipPlan(): BelongsTo
    {
        return $this->belongsTo(MembershipPlan::class);
    }
} 