<?php

declare(strict_types=1);

namespace App\Models\Membership;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PlanModule extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'membership_plan_id',
        'module_name',
        'module_allowed_images',
        'module_allow_listing',
        'module_listing_limit',
        'module_extra_listing_price',
        'is_active',
        'module_settings',
        'current_usage',
    ];

    protected $casts = [
        'module_allow_listing' => 'boolean',
        'module_extra_listing_price' => 'decimal:2',
        'is_active' => 'boolean',
        'module_settings' => 'array',
    ];

    public function membershipPlan(): BelongsTo
    {
        return $this->belongsTo(MembershipPlan::class);
    }
} 