<?php

declare(strict_types=1);

namespace App\Models\Membership;

use App\Models\User\User;
use App\Models\Membership\Purchase;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Traits\HasUuidTrait;
use App\Models\Traits\CreatedByTrait;
use App\Enums\MembershipPaymentTerm;
use App\Models\Membership\Traits\SubcriptionHelperTrait;

class Subscription extends Model
{
    use HasFactory, HasUuidTrait, CreatedByTrait, SubcriptionHelperTrait;

    protected $fillable = [
        'uuid',
        'user_id',
        'parent_id',
        'membership_plan_id',
        'purchase_date',
        'payment_term',
        'is_active',
        'auto_renewal',
        'created_by',
        'current_period_start',
        'current_period_end',
        'trial_ends_at',
        'cancelled_at',
        'status',
    ];

    protected $casts = [
        'purchase_date' => 'datetime',
        'is_active' => 'boolean',
        'auto_renewal' => 'boolean',
        'current_period_start' => 'datetime',
        'current_period_end' => 'datetime',
        'trial_ends_at' => 'datetime',
        'cancelled_at' => 'datetime',
        'payment_term' => MembershipPaymentTerm::class,
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function purchases(): HasMany
    {
        return $this->hasMany(Purchase::class, 'purchaseable_id')
            ->where('purchaseable_type', static::class);
    }

    public function membershipPlan(): BelongsTo
    {
        return $this->belongsTo(MembershipPlan::class);
    }

    public function author(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function parentSubscription(): BelongsTo
    {
        return $this->belongsTo(Subscription::class, 'parent_id');
    }
}
