<?php

namespace App\Models\Membership\Traits;
use App\Enums\MembershipPaymentTerm;
trait MembershipPlanHelperTrait
{
    public function getSubscriptionDetails()
    {
        return $this->subscription;
    }

    public function getPrice(){
        $priceTerm = $this->preferred_payment_term;
        $price = 0;
        switch($priceTerm){
            case MembershipPaymentTerm::Monthly:
                $price = $this->price_monthly;
                break;
            case MembershipPaymentTerm::Quarterly:
                $price = $this->price_quarterly;
                break;
            case MembershipPaymentTerm::SemiYearly:
                $price = $this->price_half_yearly;
                break;
            case MembershipPaymentTerm::Yearly:
                $price = $this->price_yearly;
                break;
            default:
                $price = $this->price_yearly;
                break;
        }
        
        return $price;
    }

}