<?php

namespace App\Models\Membership\Traits;

trait SubcriptionHelperTrait
{
    public function getRenewalStatus(): bool
    {
        $renewal = false;

        if (!empty($this->auto_renewal)) {
            switch ($this->auto_renewal) {
                case 1:
                    $renewal = true;
                    break;
                default:
                    $renewal = false;
            }
        }
        return $renewal;
    }

    public function getSubscriptionDate($format = 'M d, Y'): string
    {
        $subscriptionDate = $this->current_period_start;
        $startDate = '';

        if (!empty($subscriptionDate)) {
            $startDate = $subscriptionDate->format($format);
        }

        return $startDate;
    }

    public function getSubscriptionExpireDate($format = 'M d, Y'): string
    {
        $subscriptionDate = $this->current_period_end;
        $endDate = '';

        if (!empty($subscriptionDate)) {
            $endDate = $subscriptionDate->format($format);
        }

        return $endDate;
    }
}
