<?php

namespace App\Models\Project;

use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use App\Models\Project\Project;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Traits\HasUuidTrait;
use App\Models\Traits\CreatedByTrait;
use RalphJSmit\Laravel\SEO\Support\HasSEO;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ProjectType extends Model
{
    use HasFactory, HasSlug, SoftDeletes, HasUuidTrait, CreatedByTrait, HasSEO; 

    protected $fillable = [
        'type_name',
        'slug',
        'type_description',
        'parent_id',
        'is_active',
        'created_by',
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()->generateSlugsFrom('type_name')->saveSlugsTo('slug')->doNotGenerateSlugsOnUpdate();
    }

    public function projects(): BelongsToMany
    {
        return $this->belongsToMany(Project::class, 'project_project_type')
            ->withTimestamps();
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(ProjectType::class, 'parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(ProjectType::class, 'parent_id');
    }

    public function author(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }
} 
