<?php

namespace App\Models;

use App\Enums\MemberRatingType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ReviewRating extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'review_id',
        'rating_type',
        'rating',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'rating' => 'integer',
        'rating_type' => MemberRatingType::class,
    ];

    /**
     * Get the review that owns the rating.
     */
    public function review(): BelongsTo
    {
        return $this->belongsTo(Review::class);
    }
}
