<?php

namespace App\Models;

use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Setting extends Model
{
    use HasUuidTrait, CreatedByTrait, SoftDeletes;

    protected $fillable = [
        'uuid',
        'key',
        'value',
        'type',
        'group',
        'created_by',
    ];

    protected $casts = [
        'value' => 'string',
    ];

}
