<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Traits\HasUuidTrait;
use App\Models\Traits\CreatedByTrait;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use RalphJSmit\Laravel\SEO\Support\HasSEO;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Spatie\Image\Enums\Fit;


class MemberCategory extends Model implements HasMedia
{
    use SoftDeletes, HasUuidTrait, CreatedByTrait, HasSlug, HasSEO, HasFactory, InteractsWithMedia;
    protected $fillable = [
        'category_name',
        'slug',
        'category_description',
        'parent_id',
    ];

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'member_category_user');
    }

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('category_name')
            ->saveSlugsTo('slug')
            ->doNotGenerateSlugsOnUpdate();
    }
    /**
     * Get the parent category
     */
    public function parent(): BelongsTo
    {
        return $this->belongsTo(MemberCategory::class, 'parent_id');
    }

    /**
     * Get the child categories
     */
    public function children(): HasMany
    {
        return $this->hasMany(MemberCategory::class, 'parent_id');
    }

    /**
     * Register the media collection for the model.
     */
    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('category_logo')
            ->singleFile()
            ->acceptsMimeTypes(['image/png', 'image/svg+xml'])
            ->registerMediaConversions(function (Media $media) {
                $this->addMediaConversion('small')
                    ->fit(Fit::Contain, 150)
                    ->keepOriginalImageFormat()
                    ->sharpen(10);
            });

       
    }
}
