<?php

namespace App\Models\User;

use Spatie\Permission\Models\Permission as SpatiePermission;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
class MyPermission extends SpatiePermission
{
    protected $fillable = [
        'name',
        'guard_name',
        'parent_id'
    ];

    public function parent(): BelongsTo
    {
        return $this->belongsTo(MyPermission::class, 'parent_id');
    }
}
