<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserCreditHistory extends Model
{
    use HasUuidTrait, SoftDeletes;

    protected $table = 'user_credit_history';

    protected $fillable = [
        'user_id',
        'uuid',
        'debit',
        'credit',
        'balance',
        'creditable_type',
        'creditable_id',
        'created_by'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function creditable()
    {
        return $this->morphTo();
    }

    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
