<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use App\Models\Traits\HasUuidTrait;

class UserFavorite extends Model
{
    use HasUuidTrait;
    protected $table = 'user_favorites';

    protected $fillable = [
        'uuid',
        'user_id',
        'model_type',
        'model_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function model()
    {
        return $this->morphTo(__FUNCTION__, 'model_type', 'model_id');
    }
}
