<?php

declare(strict_types=1);

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use App\Models\Traits\HasUuidTrait;
use App\Models\Traits\CreatedByTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use App\Models\Location\City;
use App\Models\Location\State;
use App\Models\Location\Country;
use App\Models\Location\Area;

class UserLocation extends Model
{
    use HasFactory, HasUuidTrait, CreatedByTrait, SoftDeletes;

    protected $fillable = [
        'uuid',
        'user_id',
        'location_name',
        'contact_person_name',
        'phone',
        'email',
        'fax',
        'map_address',
        'address_line_1',
        'address_line_2',
        'postal_code',
        'latitude',
        'longitude',
        'is_active',
        'city_id',
        'state_id',
        'country_id',
        'primary_location',
        'created_by',
    ];

    protected $casts = [
        'primary_location' => 'boolean',
        'is_active' => 'boolean',
        'latitude' => 'float',
        'longitude' => 'float',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function city(): BelongsTo
    {
        return $this->belongsTo(City::class);
    }

    public function state(): BelongsTo
    {
        return $this->belongsTo(State::class);
    }

    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class);
    }

    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function areas(): BelongsToMany
    {
        return $this->belongsToMany(Area::class, 'area_location', 'location_id', 'area_id');
    }
}
