<?php

namespace App\Models\User;

use App\Enums\UserProfileStatus;
use Illuminate\Database\Eloquent\Model;
use App\Enums\UserProfileType;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User\MyRole;
use Kodeine\Metable\Metable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserProfile extends Model
{
    use HasUuidTrait, Metable, HasFactory;

    protected $metaTable = 'user_profiles_meta'; //optional.

    protected $fillable = [
        'user_id',
        'first_name',
        'last_name',
        'company_name',
        'credit_balance',
        'profile_type',
        'year_established',
        'credentials',
        'service_areas',
        'about',
        'phone',
        'mobile',
        'fax',
        'website',
        'business_hours',
        'social_media_links',
        'slogan',
        'services',
        'other_services',
        'status',
        'profile_rating'
    ];

    public $meta_fields = [
        'business_timezone',
        'seasonal_hours',
        'awards_recognitions',
        'support_services',
        'why_choose_us',
        'emergency_service_enabled',
        'emergency_service_title',
        'emergency_service_description',
        'emergency_service_number',
        'profile_tags',
        'faqs',
    ];


    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected $casts = [
        'social_media_links' => 'array',
        'profile_type' => UserProfileType::class,
        'status' => UserProfileStatus::class,
        'business_hours' => 'array',
        'seasonal_hours' => 'array',
        'credentials' => 'array',
        'service_areas' => 'array',
        'support_services' => 'array',
        'why_choose_us' => 'array',
        'profile_rating' => 'float',
        'profile_tags' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the user's role through the user relationship.
     */
    public function role(): BelongsTo
    {
        return $this->user->role();
    }

    public function getFullNameAttribute(): string
    {
        return $this->first_name . ' ' . $this->last_name;
    }
}
