<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Traits\HasUuidTrait;
use App\Models\Traits\CreatedByTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserService extends Model
{
    use HasFactory, HasUuidTrait, CreatedByTrait;

    protected $fillable = [
        'uuid',
        'user_id',
        'service_title',
        'service_order',
        'service_description',
        'created_by'
    ];

    protected $casts = [
        'service_order' => 'integer',
    ];

    protected static function boot()
    {
        parent::boot();

        // Set default order when creating a new service
        static::creating(function ($service) {
            if (is_null($service->service_order)) {
                $service->service_order = static::where('user_id', $service->user_id)->max('service_order') + 1;
            }
        });
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function getBySlug($slug)
    {
        return $this->where('slug', $slug)->first();
    }
}
