<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use App\Enums\WidgetComponentType;
use App\Models\Traits\HasUuidTrait;
use App\Models\User\User;


class Widget extends Model
{
    use HasFactory, SoftDeletes, HasUuidTrait;

    protected $fillable = [
        'uuid',
        'title',
        'component',
        'component_type',
        'data',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'data' => 'array',
        'component_type' => WidgetComponentType::class,
    ];

    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function pages(): BelongsToMany
    {
        return $this->belongsToMany(Page::class, 'page_widget')
            ->withPivot(['sort_order', 'enable'])
            ->withTimestamps();
    }

    
}
