<?php

namespace App\Observers;

use App\Models\Classified\Classified;
use App\Enums\ClassifiedStatus;
use Illuminate\Support\Facades\Cache;

class ClassifiedObserver
{
    /**
     * Handle the Classified "created" event.
     */
    public function created(Classified $classified): void
    {
        //
    }

    /**
     * Handle the Classified "updated" event.
     */
    public function updated(Classified $classified): void
    {
        //
    }

    /**
     * Handle the Post "created" and "updated" event.
     */
    public function saved(Classified $classified): void
    {
        Cache::forget('classified-status-counts');
    }

    /**
     * Handle the Classified "deleted" event.
     */
    public function deleted(Classified $classified): void
    {
        $classified->update(['classified_status' => ClassifiedStatus::Trashed]);
        Cache::forget('classified-status-counts');
    }

    /**
     * Handle the Classified "restored" event.
     */
    public function restored(Classified $classified): void
    {
        if($classified->classified_status == ClassifiedStatus::Trashed) {
            $classified->update(['classified_status' => ClassifiedStatus::Draft]);
        }
        Cache::forget('classified-status-counts');
    }

    /**
     * Handle the Classified "force deleted" event.
     */
    public function forceDeleted(Classified $classified): void
    {
        //
    }

    public function deleting(Classified $classified): void
    {
        if ($classified->is_featured) {
            $classified->is_featured = false;
            $classified->saveQuietly();
        }
    }
}
