<?php

namespace App\Observers;
use App\Models\Membership\MembershipPlan;

class MembershipPlanObserver
{
    /**
     * Handle the MemberPlan "saving" event.
     *
     * @param  \App\Models\Membership\MembershipPlan  $memberPlan
     * @return void
     */
    public function saving(MembershipPlan $membershipPlan)
    {
        // Set other plans as not featured
        if ($membershipPlan->isDirty('is_featured') && $membershipPlan->is_featured) {
            MembershipPlan::where('id', '!=', $membershipPlan->id)
                ->update(['is_featured' => false]);
        }
        // Set other plans as not best value
        if ($membershipPlan->isDirty('is_best_value') && $membershipPlan->is_best_value) {
            MembershipPlan::where('id', '!=', $membershipPlan->id)
                ->update(['is_best_value' => false]);
        }
        // Set other plans as not most popular
        if ($membershipPlan->isDirty('is_most_popular') && $membershipPlan->is_most_popular) {
            MembershipPlan::where('id', '!=', $membershipPlan->id)
                ->update(['is_most_popular' => false]);
        }
    }
}
