<?php

namespace App\Observers;

use App\Models\User\UserVideo;

class UserVideoObserver
{
    /**
     * Handle the UserVideo "saving" event.
     *
     * @param  \App\Models\User\UserVideo  $userVideo
     * @return void
     */
    public function saving(UserVideo $userVideo)
    {
        if ($userVideo->isDirty('is_featured') && $userVideo->is_featured) {
            UserVideo::where('user_id', $userVideo->user_id)
                ->where('id', '!=', $userVideo->id)
                ->update(['is_featured' => false]);
        }
    }
}
