<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use FilamentTiptapEditor\TiptapEditor;
use App\Filament\TipTapEditor\TiptapBlock\ButtonBlock;
use App\Filament\TipTapEditor\TiptapBlock\AdsBlock;
use App\Filament\TipTapEditor\TiptapBlock\ImageWithCaption;
use App\Filament\TipTapEditor\TiptapBlock\ImageAdBlock;
use App\Services\Settings\SettingsManager;
use Illuminate\Support\Facades\Gate;
use App\Models\User\User;
use Livewire\Livewire;
use Laravel\Cashier\Cashier;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Str;

class AppServiceProvider extends ServiceProvider
{


    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Register SettingsManager as singleton
        $this->app->singleton(SettingsManager::class);
        // Register GateServiceProvider as singleton
        $this->app->singleton(GateServiceProvider::class);

        TiptapEditor::configureUsing(function (TiptapEditor $component) {
            $component
                ->blocks([
                    AdsBlock::class,
                    ButtonBlock::class,
                    ImageWithCaption::class,
                    ImageAdBlock::class,
                ]);
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Livewire::addPersistentMiddleware([
            \Hexadog\ThemesManager\Http\Middleware\ThemeLoader::class,
            \App\Http\Middleware\ThemeLoader::class,
        ]);

        // Register model observers
        \App\Models\User\UserVideo::observe(\App\Observers\UserVideoObserver::class);
        \App\Models\Membership\MembershipPlan::observe(\App\Observers\MembershipPlanObserver::class);   
        \App\Models\Setting::observe(\App\Observers\SettingObserver::class);
        \App\Models\User\UserCreditHistory::observe(\App\Observers\UserCreditHistoryObserver::class);
        \App\Models\Review::observe(\App\Observers\ReviewObserver::class);

        Cashier::useCustomerModel(User::class);

        // Make Str class globally available in all Blade views
        view()->share('Str', Str::class);
    }
}
