<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Filament\Notifications\Livewire\DatabaseNotifications;
use Filament\Support\Colors\Color;
use Filament\Support\Facades\FilamentColor;

class DashboardServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register the DatabaseNotifications component
        // DatabaseNotifications::trigger('dashboard.includes.notification-button');
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        DatabaseNotifications::trigger('filament.dashboard.notifications.database-notifications-trigger');

        FilamentColor::register([
            'danger' => Color::Red,
            'gray' => Color::Zinc,
            'info' => Color::Blue,
            'primary' => Color::hex('#0172B1'),
            'success' => Color::Green,
            'warning' => Color::Amber,
        ]);
    }
}
