<?php

namespace App\Providers\Filament;

use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Support\Enums\MaxWidth;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use Filament\Navigation\NavigationItem;
use Filament\Pages\Dashboard;
use Filament\Navigation\NavigationGroup;
use Filament\Navigation\NavigationBuilder;
use App\Filament\Resources\Blog\PostResource;
use App\Filament\Resources\Blog\PostCategoryResource;
use App\Filament\Resources\Blog\PostTagResource;
use App\Filament\Resources\Classified\ClassifiedResource;
use App\Filament\Resources\Classified\ClassifiedCategoryResource;
use App\Filament\Resources\Classified\ClassifiedTagResource;
use App\Filament\Resources\Classified\ClassifiedTypeResource;
use App\Filament\Resources\Job\JobResource;
use App\Filament\Resources\Job\JobApplicationResource;
use App\Filament\Resources\Job\JobCareerLevelResource;
use App\Filament\Resources\Job\JobIndustryResource;
use App\Filament\Resources\Job\JobRoleResource;
use App\Filament\Resources\Job\JobSkillResource;
use App\Filament\Resources\Job\JobTypeResource;
use Althinect\FilamentSpatieRolesPermissions\FilamentSpatieRolesPermissionsPlugin;
use App\Filament\Resources\User\UserResource;
use App\Filament\Resources\User\RoleResource;
use App\Filament\Resources\User\PermissionResource;
use App\Filament\Resources\Member\MemberResource;
use App\Filament\Resources\Member\MemberCategoryResource;
use App\Filament\Resources\Supplier\SupplierResource;
use App\Filament\Resources\Manufacturer\ManufacturerResource;
use App\Filament\Resources\Page\PageResource;
use App\Filament\Pages\Settings;
use App\Filament\Resources\Location\CountryResource;
use App\Filament\Resources\Location\StateResource;
use App\Filament\Resources\Location\CityResource;
use App\Filament\Resources\Membership\MembershipPlanResource;
use App\Filament\Resources\Membership\SubscriptionResource;
use App\Filament\Resources\Team\TeamMemberResource;
use App\Filament\Resources\Project\ProjectResource;
use App\Filament\Resources\Project\ProjectTypeResource;
use App\Filament\Resources\Lead\LeadResource;
use App\Filament\Resources\Lead\LeadFormResource;
use App\Filament\Resources\Lead\LeadFormFieldsResource;
use App\Filament\Resources\Product\ProductResource;
use App\Filament\Resources\Product\ProductCategoryResource;
use App\Filament\Resources\Equipment\EquipmentResource;
use App\Filament\Resources\Equipment\EquipmentCategoryResource;
use App\Filament\Resources\Member\VideoResource;
use App\Filament\Resources\Classified\ClassifiedDeliveryResource;
use App\Filament\Resources\Review\ReviewResource;
use App\Filament\Resources\Membership\InvoiceResource;
use App\Filament\Resources\Membership\TransectionHistoryResource;
use App\Filament\Resources\Location\AreaResource;
use App\Filament\Resources\Page\WidgetResource;
use App\Filament\Resources\ApiClient\ApiClientResource;

class EspadminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->default()
            ->id('espadmin')
            ->path('espadmin')
            ->login()
            ->brandName('ESP Admin')
            ->brandLogo(asset('images/light_logo.png'))
            ->brandLogoHeight('auto')
            ->plugins([
                FilamentSpatieRolesPermissionsPlugin::make(),
                \Biostate\FilamentMenuBuilder\FilamentMenuBuilderPlugin::make()
            ])
            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\\Filament\\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\\Filament\\Pages')
            ->pages([
                Pages\Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\\Filament\\Widgets')
            ->widgets([
                Widgets\AccountWidget::class,
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([
                Authenticate::class,
            ])
            ->viteTheme([
                'resources/css/esp_admin/filament.css'
            ])
            ->colors([
                'danger' => Color::Rose,
                'gray' => Color::Gray,
                'info' => Color::Blue,
                'primary' => "#0172B1",
                'success' => Color::Emerald,
                'warning' => Color::Orange,
            ])
            ->font('Poppins')
            ->maxContentWidth(MaxWidth::Full)
            ->databaseNotifications()
            ->passwordReset()
            ->emailVerification()
            ->sidebarCollapsibleOnDesktop()
            ->profile()
            ->databaseTransactions()
            ->navigationItems([
                NavigationItem::make('dashboard')
                    ->icon('fas-home')
                    ->label(fn(): string => __('filament-panels::pages/dashboard.title'))
                    ->url(fn(): string => Dashboard::getUrl())
                    ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.pages.dashboard')),
            ])
            ->navigation(function (NavigationBuilder $builder): NavigationBuilder {
                $builder->items([
                    NavigationItem::make('Dashboard')
                        ->icon('heroicon-o-home')
                        ->url(Dashboard::getUrl())
                        ->sort(1),
                ])->groups([
                    NavigationGroup::make('Member')
                        ->icon('heroicon-o-user')
                        ->items([
                            NavigationItem::make('All Members')
                                ->url(MemberResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.member.members.index'))
                                ->sort(1),
                            NavigationItem::make('Add New Member')
                                ->url(MemberResource::getUrl('create'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.member.members.create'))
                                ->sort(2),
                            ...MemberCategoryResource::getNavigationItems(),
                            NavigationItem::make('All Videos')
                                ->url(VideoResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.member.videos.index'))
                                ->sort(4),
                            NavigationItem::make('Add New Video')
                                ->url(VideoResource::getUrl('create'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.member.videos.create'))
                                ->sort(4),
                            NavigationItem::make('Reviews')
                                ->url(ReviewResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.review.reviews.index'))
                                ->sort(5),
                        ]),
                    NavigationGroup::make('Mfg & Supplier')
                        ->icon('heroicon-o-truck')
                        ->items([
                            NavigationItem::make('Suppliers')
                                ->url(SupplierResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.supplier.suppliers.index'))
                                ->sort(1),
                            NavigationItem::make('Manufacturers')
                                ->url(ManufacturerResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.manufacturer.manufacturers.index'))
                                ->sort(2),
                            NavigationItem::make('Products')
                                ->url(ProductResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.product.products.index'))
                                ->sort(3),
                            NavigationItem::make('Product Categories')
                                ->url(ProductCategoryResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.product.product-categories.index'))
                                ->sort(4),
                        ]),
                    NavigationGroup::make('Blog')
                        ->icon('heroicon-o-newspaper')
                        ->items([
                            NavigationItem::make('All Posts')
                                ->url(PostResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.blog.posts.index'))
                                ->sort(1),
                            NavigationItem::make('Add New Post')
                                ->url(PostResource::getUrl('create'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.blog.posts.create'))
                                ->sort(2),
                            ...PostCategoryResource::getNavigationItems(),
                            ...PostTagResource::getNavigationItems(),
                        ]),
                    NavigationGroup::make('Classified')
                        ->icon('heroicon-o-rectangle-stack')
                        ->items([
                            NavigationItem::make('All Classifieds')
                                ->url(ClassifiedResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.classified.classifieds.index'))
                                ->sort(1),
                            NavigationItem::make('Add New Classified')
                                ->url(ClassifiedResource::getUrl('create'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.classified.classifieds.create'))
                                ->sort(2),
                            ...ClassifiedCategoryResource::getNavigationItems(),
                            ...ClassifiedTypeResource::getNavigationItems(),
                            ...ClassifiedTagResource::getNavigationItems(),
                            ...ClassifiedDeliveryResource::getNavigationItems(),
                        ]),
                    NavigationGroup::make('Job')
                        ->icon('heroicon-o-briefcase')
                        ->items([
                            NavigationItem::make('All Jobs')
                                ->url(JobResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.job.jobs.index'))
                                ->sort(1),
                            NavigationItem::make('Add New Job')
                                ->url(JobResource::getUrl('create'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.job.jobs.create'))
                                ->sort(2),
                            ...JobApplicationResource::getNavigationItems(),
                            ...JobCareerLevelResource::getNavigationItems(),
                            ...JobIndustryResource::getNavigationItems(),
                            ...JobRoleResource::getNavigationItems(),
                            ...JobSkillResource::getNavigationItems(),
                            ...JobTypeResource::getNavigationItems(),
                        ]),
                    NavigationGroup::make('Team')
                        ->icon('heroicon-o-users')
                        ->items([
                            NavigationItem::make('Team Members')
                                ->url(TeamMemberResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.team.team-members.index'))
                                ->sort(1),
                            NavigationItem::make('Add New')
                                ->url(TeamMemberResource::getUrl('create'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.team.team-members.create'))
                                ->sort(2),
                        ]),
                    NavigationGroup::make('Equipment')
                        ->icon('heroicon-o-users')
                        ->items([
                            NavigationItem::make('All Equipment')
                                ->url(EquipmentResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.equipment.equipments.index'))
                                ->sort(1),
                            NavigationItem::make('Add New')
                                ->url(EquipmentResource::getUrl('create'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.equipment.equipments.create'))
                                ->sort(2),
                            NavigationItem::make('Categories')
                                ->url(EquipmentCategoryResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.equipment.equipment-categories.index'))
                                ->sort(3),
                        ]),
                    NavigationGroup::make('Project')
                        ->icon('heroicon-o-building-office')
                        ->items([
                            NavigationItem::make('All Projects')
                                ->url(ProjectResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.project.projects.index'))
                                ->sort(1),
                            NavigationItem::make('Add New Project')
                                ->url(ProjectResource::getUrl('create'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.project.projects.create'))
                                ->sort(2),
                            NavigationItem::make('Project Categories')
                                ->url(ProjectTypeResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.project.project-types.index'))
                                ->sort(3),
                        ]),
                    NavigationGroup::make('Membership')
                        ->icon('heroicon-o-credit-card')
                        ->items([
                            NavigationItem::make('All Plans')
                                ->url(MembershipPlanResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.membership.membership-plans.index'))
                                ->sort(1),
                            NavigationItem::make('Add New Plan')
                                ->url(MembershipPlanResource::getUrl('create'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.membership.membership-plans.create'))
                                ->sort(2),
                            NavigationItem::make('Subscriptions')
                                ->url(SubscriptionResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.membership.subscriptions.index'))
                                ->sort(3),
                            NavigationItem::make('Invoices')
                                ->url(InvoiceResource::getUrl('index'))
                                ->label('Invoices')
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.membership.purchases.index'))
                                ->sort(4),
                        ]),
                    NavigationGroup::make('Lead')
                        ->icon('heroicon-o-user-group')
                        ->items([
                            NavigationItem::make('All Leads')
                                ->url(LeadResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.lead.leads.index'))
                                ->sort(1),
                            NavigationItem::make('Lead Forms')
                                ->url(LeadFormResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.lead.lead-forms.index'))
                                ->sort(2),
                            NavigationItem::make('Lead Form Fields')
                                ->url(LeadFormFieldsResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.lead.lead-form-fields.index'))
                                ->sort(3),
                        ]),
                    NavigationGroup::make('Users')
                        ->icon('heroicon-o-user-group')
                        ->items([
                            ...UserResource::getNavigationItems(),
                            ...RoleResource::getNavigationItems(),
                            ...PermissionResource::getNavigationItems(),
                        ]),
                    NavigationGroup::make('Pages')
                        ->icon('heroicon-o-document-text')
                        ->items([
                            NavigationItem::make('All Pages')
                                ->url(PageResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.page.pages.index'))
                                ->sort(1),
                            NavigationItem::make('Menu')
                                ->url(route('filament.espadmin.resources.menus.index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.menus.index'))
                                ->sort(2),
                            NavigationItem::make('Widgets')
                                ->url(WidgetResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.widgets.index'))
                                ->sort(3),
                        ]),
                    NavigationGroup::make('Location Management')
                        ->icon('heroicon-o-map')
                        ->items([
                            ...CountryResource::getNavigationItems(),
                            ...StateResource::getNavigationItems(),
                            ...CityResource::getNavigationItems(),
                            ...AreaResource::getNavigationItems(),
                        ]),
                    // Setting Navigation
                    NavigationGroup::make('Settings')
                        ->icon('heroicon-o-cog')
                        ->items([
                            NavigationItem::make('General Settings')
                                ->icon('heroicon-o-cog-6-tooth')
                                ->url(Settings::getUrl())
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.pages.settings'))
                                ->sort(1),
                            NavigationItem::make('API Clients')
                                ->icon('heroicon-o-key')
                                ->url(ApiClientResource::getUrl('index'))
                                ->isActiveWhen(fn() => request()->routeIs('filament.espadmin.resources.api-client.api-clients.*'))
                                ->badge(fn() => \App\Models\ApiClient::where('is_active', true)->count())
                                ->sort(2),
                        ]),
                ]);
                return $builder;
            });
    }
}
