<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\User\User;
use App\Helpers\ConstantHelper;
use App\Models\Blog\Post;
use App\Models\Classified\Classified;
use App\Models\Job\Job;
use App\Models\Job\JobApplication;
use App\Models\Lead\Lead;
use App\Models\User\MemberCategory;
use App\Models\User\UserCreditHistory;
use App\Models\User\UserLocation;
use App\Policies\Blog\PostPolicy;
use App\Policies\Classified\ClassifiedPolicy;
use App\Policies\Job\JobApplicationPolicy;
use App\Policies\Job\JobPolicy;
use App\Policies\Lead\LeadPolicy;
use App\Policies\Users\MemberCategoryPolicy;
use App\Policies\Users\UserCreditHistoryPolicy;
use App\Policies\Users\UserLocationPolicy;
use App\Models\User\Inquiry;
use App\Policies\Users\InquiryPolicy;
use App\Models\Project\Project;
use App\Policies\Project\ProjectPolicy;
use App\Models\Team\TeamMember;
use App\Policies\Team\TeamMemberPolicy;
use App\Models\Equipment\Equipment;
use App\Policies\Equipment\EquipmentPolicy;
use App\Models\Review;
use App\Policies\ReviewPolicy;
use App\Models\User\UserVideo;
use App\Policies\Users\UserVideoPolicy;
use App\Models\Product\Product;
use App\Policies\Product\ProductPolicy;


class GateServiceProvider extends ServiceProvider
{

    /**
     * Register services.
     */
    public function register(): void {}

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        Gate::policy(MemberCategory::class, MemberCategoryPolicy::class);

        Gate::policy(UserLocation::class, UserLocationPolicy::class);

        Gate::policy(UserCreditHistory::class, UserCreditHistoryPolicy::class);
        Gate::policy(Lead::class, LeadPolicy::class);
        Gate::policy(Classified::class, ClassifiedPolicy::class);
        Gate::policy(Job::class, JobPolicy::class);
        Gate::policy(JobApplication::class, JobApplicationPolicy::class);
        Gate::policy(Post::class, PostPolicy::class);
        Gate::policy(Inquiry::class, InquiryPolicy::class);
        Gate::policy(Project::class, ProjectPolicy::class);
        Gate::policy(TeamMember::class, TeamMemberPolicy::class);
        Gate::policy(Equipment::class, EquipmentPolicy::class);
        Gate::policy(Review::class, ReviewPolicy::class);
        Gate::policy(UserVideo::class, UserVideoPolicy::class);
        Gate::policy(Product::class, ProductPolicy::class);

        Gate::define('isSuperAdmin', function (User $user) {
            return $user->hasRole('SuperAdmin');
        });

        //Admin user role
        Gate::define('isAdmin', function (User $user) {
            return $user->hasRole(ESP_ROLE_ADMIN);
        });


        //Member user role
        Gate::define('isService', function (User $user) {
            return $user->hasRole('Service');
        });

        Gate::define('isManufacturer', function (User $user) {
            return $user->hasRole('Manufacturer');
        });

        Gate::define('isSupplier', function (User $user) {
            return $user->hasRole('Supplier');
        });

        Gate::define('isSubscriber', function (User $user) {
            return $user->hasRole('Subscriber');
        });

        Gate::define('isMfgSupplier', function (User $user) {
            return $user->hasAnyRole(['Manufacturer', 'Supplier']);
        });

        // User Profile
        Gate::define('userProfileBusinessDescription', function () {
            return true;
        });

        Gate::define('userProfileProfessionalCredentials', function () {
            return true;
        });

        Gate::define('userProfileAwards&Recognitions', function () {
            return true;
        });

        Gate::define("userProfileServiceArea", function () {
            return true;
        });

        Gate::define('userProfileBusinessHours', function () {
            return true;
        });

        Gate::define('userProfileSeasonalHours', function () {
            return true;
        });

        Gate::define('userProfileSocialMediaLinks', function () {
            return true;
        });
        //user profile gates end

        //user gallery images gate
        Gate::define('userGalleryUploadImages', function () {
            return true;
        });
        // user gallery images gate end

        //user service gates
        Gate::define('userServiceSupportedServices', function () {
            return true;
        });

        Gate::define('userServiceWhyChooseUs', function () {
            return true;
        });
        Gate::define('userServiceEmergencyServices', function () {
            return true;
        });
        //user service gates end

        Gate::define("account&Subscription", function () {
            return true;
        });
    }
}
