<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Repositories\Contracts\Blog\PostRepositoryInterface;
use App\Repositories\Eloquent\Blog\PostRepository;
use App\Repositories\Contracts\Blog\PostCategoryRepositoryInterface;
use App\Repositories\Eloquent\Blog\PostCategoryRepository;
use App\Repositories\Contracts\Blog\PostTagRepositoryInterface;
use App\Repositories\Eloquent\Blog\PostTagRepository;
use App\Repositories\Contracts\User\UserRepositoryInterface;
use App\Repositories\Eloquent\User\UserRepository;
use App\Repositories\Contracts\Classified\ClassifiedRepositoryInterface;
use App\Repositories\Eloquent\Classified\ClassifiedRepository;
use App\Repositories\Contracts\Job\JobRepositoryInterface;
use App\Repositories\Eloquent\Job\JobRepository;
use App\Repositories\Contracts\Job\JobRoleRepositoryInterface;
use App\Repositories\Eloquent\Job\JobRoleRepository;
use App\Repositories\Contracts\Job\JobTypeRepositoryInterface;
use App\Repositories\Eloquent\Job\JobTypeRepository;
use App\Repositories\Contracts\Job\JobIndustryRepositoryInterface;
use App\Repositories\Eloquent\Job\JobIndustryRepository;
use App\Repositories\Contracts\Job\JobSkillRepositoryInterface;
use App\Repositories\Eloquent\Job\JobSkillRepository;
use App\Repositories\Contracts\Job\JobCareerLevelRepositoryInterface;
use App\Repositories\Eloquent\Job\JobCareerLevelRepository;
use App\Repositories\Contracts\Job\JobApplicationRepositoryInterface;
use App\Repositories\Eloquent\Job\JobApplicationRepository;
use App\Repositories\Contracts\Project\ProjectRepositoryInterface;
use App\Repositories\Eloquent\Project\ProjectRepository;
use App\Repositories\Contracts\Team\TeamMemberRepositoryInterface;
use App\Repositories\Eloquent\Team\TeamMemberRepository;
use App\Repositories\Contracts\Product\ProductRepositoryInterface;
use App\Repositories\Eloquent\Product\ProductRepository;
use App\Repositories\Contracts\User\UserServiceRepositoryInterface;
use App\Repositories\Eloquent\User\UserServiceRepository;
use App\Repositories\Contracts\User\UserLocationRepositoryInterface;
use App\Repositories\Eloquent\User\UserLocationRepository;
use App\Repositories\Contracts\User\MemberCategoryRepositoryInterface;
use App\Repositories\Eloquent\User\MemberCategoryRepository;
use App\Repositories\Contracts\User\UserVideoRepositoryInterface;
use App\Repositories\Eloquent\User\UserVideoRepository;
use App\Repositories\Contracts\Equipment\EquipmentRepositoryInterface;
use App\Repositories\Eloquent\Equipment\EquipmentRepository;
use App\Repositories\Contracts\Location\CountryRepositoryInterface;
use App\Repositories\Eloquent\Location\CountryRepository;
use App\Repositories\Contracts\Location\StateRepositoryInterface;
use App\Repositories\Eloquent\Location\StateRepository;
use App\Repositories\Contracts\Location\CityRepositoryInterface;
use App\Repositories\Eloquent\Location\CityRepository;
use App\Repositories\Contracts\Review\ReviewRepositoryInterface;
use App\Repositories\Eloquent\Review\ReviewRepository;
use App\Repositories\Contracts\Classified\ClassifiedTypeRepositoryInterface;
use App\Repositories\Eloquent\Classified\ClassifiedTypeRepository;
use App\Repositories\Contracts\Classified\ClassifiedCategoryRepositoryInterface;
use App\Repositories\Eloquent\Classified\ClassifiedCategoryRepository;
use App\Repositories\Contracts\Classified\ClassifiedDeliveryRepositoryInterface;
use App\Repositories\Eloquent\Classified\ClassifiedDeliveryRepository;
use App\Repositories\Contracts\User\UserSubscriptionRepositoryInterface;
use App\Repositories\Eloquent\User\UserSubscriptionRepository;
use App\Repositories\Contracts\User\MemberPlanRepositoryInterface;
use App\Repositories\Eloquent\User\MemberPlanRepository;
use App\Repositories\Contracts\Inquiry\InquiryRepositoryInterface;
use App\Repositories\Eloquent\Inquiry\InquiryRepository;
use App\Services\Inquiry\InquiryService;
use App\Repositories\Contracts\Lead\LeadRepositoryInterface;
use App\Repositories\Eloquent\Lead\LeadRepository;
use App\Repositories\Contracts\Lead\LeadFormRepositoryInterface;
use App\Repositories\Eloquent\Lead\LeadFormRepository;
use App\Repositories\Contracts\Lead\LeadFormFieldRepositoryInterface;
use App\Repositories\Eloquent\Lead\LeadFormFieldRepository;
use App\Repositories\Contracts\Lead\LeadFormVisitRepositoryInterface;
use App\Repositories\Eloquent\Lead\LeadFormVisitRepository;
use App\Repositories\Contracts\Credit\CreditRepositoryInterface;
use App\Repositories\Eloquent\Credit\CreditRepository;
use App\Services\Purchase\PurchaseService;
use App\Services\Payment\PaymentService;
use App\Repositories\Contracts\Purchase\PurchaseRepositoryInterface;
use App\Repositories\Eloquent\Purchase\PurchaseRepository;
use App\Repositories\Contracts\Payment\PaymentRepositoryInterface;
use App\Repositories\Eloquent\Payment\PaymentRepository;
use App\Repositories\Contracts\Settings\SettingRepositoryInterface;
use App\Repositories\Eloquent\Settings\SettingRepository;
use App\Repositories\Contracts\User\UserFavoriteRepositoryInterface;
use App\Repositories\Eloquent\User\UserFavoriteRepository;
use App\Repositories\Contracts\ApiClient\ApiClientRepositoryInterface;
use App\Repositories\Eloquent\ApiClient\ApiClientRepository;

class RepositoryServiceProvider extends ServiceProvider
{
        public function register(): void
        {
                $this->app->bind(PostRepositoryInterface::class, PostRepository::class);
                $this->app->bind(ClassifiedRepositoryInterface::class, ClassifiedRepository::class);
                $this->app->bind(PostCategoryRepositoryInterface::class, PostCategoryRepository::class);
                $this->app->bind(PostTagRepositoryInterface::class, PostTagRepository::class);
                $this->app->bind(UserRepositoryInterface::class, UserRepository::class);
                $this->app->bind(UserServiceRepositoryInterface::class, UserServiceRepository::class);
                $this->app->bind(UserVideoRepositoryInterface::class, UserVideoRepository::class);
                $this->app->bind(JobRepositoryInterface::class, JobRepository::class);
                $this->app->bind(JobRoleRepositoryInterface::class, JobRoleRepository::class);
                $this->app->bind(JobTypeRepositoryInterface::class, JobTypeRepository::class);
                $this->app->bind(JobIndustryRepositoryInterface::class, JobIndustryRepository::class);
                $this->app->bind(JobSkillRepositoryInterface::class, JobSkillRepository::class);
                $this->app->bind(JobCareerLevelRepositoryInterface::class, JobCareerLevelRepository::class);
                $this->app->bind(JobApplicationRepositoryInterface::class, JobApplicationRepository::class);
                $this->app->bind(ProjectRepositoryInterface::class, ProjectRepository::class);
                $this->app->bind(TeamMemberRepositoryInterface::class, TeamMemberRepository::class);
                $this->app->bind(ProductRepositoryInterface::class, ProductRepository::class);
                $this->app->bind(UserLocationRepositoryInterface::class, UserLocationRepository::class);
                $this->app->bind(MemberCategoryRepositoryInterface::class, MemberCategoryRepository::class);
                $this->app->bind(EquipmentRepositoryInterface::class, EquipmentRepository::class);
                $this->app->bind(CountryRepositoryInterface::class, CountryRepository::class);
                $this->app->bind(StateRepositoryInterface::class, StateRepository::class);
                $this->app->bind(CityRepositoryInterface::class, CityRepository::class);
                $this->app->bind(ReviewRepositoryInterface::class, ReviewRepository::class);
                $this->app->bind(ClassifiedTypeRepositoryInterface::class, ClassifiedTypeRepository::class);
                $this->app->bind(ClassifiedCategoryRepositoryInterface::class, ClassifiedCategoryRepository::class);
                $this->app->bind(ClassifiedDeliveryRepositoryInterface::class, ClassifiedDeliveryRepository::class);
                $this->app->bind(UserSubscriptionRepositoryInterface::class, UserSubscriptionRepository::class);
                $this->app->bind(MemberPlanRepositoryInterface::class, MemberPlanRepository::class);
                $this->app->bind(InquiryRepositoryInterface::class, InquiryRepository::class);
                $this->app->bind(SettingRepositoryInterface::class, SettingRepository::class);
                $this->app->bind(LeadRepositoryInterface::class, LeadRepository::class);
                $this->app->bind(LeadFormRepositoryInterface::class, LeadFormRepository::class);
                $this->app->bind(LeadFormFieldRepositoryInterface::class, LeadFormFieldRepository::class);
                $this->app->bind(LeadFormVisitRepositoryInterface::class, LeadFormVisitRepository::class);
                $this->app->bind(CreditRepositoryInterface::class, CreditRepository::class);
                $this->app->bind(UserFavoriteRepositoryInterface::class, UserFavoriteRepository::class);
                $this->app->bind(ApiClientRepositoryInterface::class, ApiClientRepository::class);

                // Bind Purchase Service
                $this->app->singleton(PurchaseService::class, function ($app) {
                        return new PurchaseService($app->make(PurchaseRepositoryInterface::class));
                });

                // Bind Payment Service
                $this->app->singleton(PaymentService::class, function ($app) {
                        return new PaymentService($app->make(PaymentRepositoryInterface::class));
                });

                // Bind Purchase Repository
                $this->app->bind(PurchaseRepositoryInterface::class, PurchaseRepository::class);

                // Bind Payment Repository
                $this->app->bind(PaymentRepositoryInterface::class, PaymentRepository::class);
        }
}
