<?php

namespace App\Providers;

use App\View\Composers\FooterComposer;
use App\View\Composers\ProfileComposer;
use App\View\Composers\ThemeComposer;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use App\View\Composers\HeaderComposer;

class ViewComposerServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Using class based composers...
        View::composer([
            'layouts.includes.header.header',
            'layouts.includes.header.header-v1',
            'layouts.includes.header.head'
        ], HeaderComposer::class);
        // Using class based composers...
        View::composer([
            'layouts.includes.footer.footer',
        ], FooterComposer::class);  

        // Make theme name available to all views
        View::composer('*', ThemeComposer::class);

        $googleMapsApiKey = config('services.google.maps_api_key', '');
        $googleMapsLibraries = 'places';

        View::share('googleMapsApiKey', $googleMapsApiKey);
        View::share('googleMapsLibraries', $googleMapsLibraries);
    }
}
