<?php

namespace App\Repositories\Contracts\ApiClient;

use App\Models\ApiClient;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;

interface ApiClientRepositoryInterface
{
    public function getAll(array $filters = [], array $with = []): LengthAwarePaginator;

    public function getAllActive(array $with = []): Collection;

    public function findById(int $id, array $with = []): ?ApiClient;

    public function findByIdOrFail(int $id, array $with = []): ApiClient;

    public function create(array $data): ApiClient;

    public function update(ApiClient $apiClient, array $data): ApiClient;

    public function delete(ApiClient $apiClient): bool;

    public function activate(ApiClient $apiClient): ApiClient;

    public function deactivate(ApiClient $apiClient): ApiClient;

    public function revokeAllTokens(ApiClient $apiClient): void;
}
