<?php

namespace App\Repositories\Contracts\Blog;

interface PostRepositoryInterface
{
    public function getAll();

    public function getScheduledForPublishing();

    public function find($id);

    public function findBySlug($slug);

    public function findByUuid(string $uuid);

    public function create(array $data);

    public function update($id, array $data);

    public function updateByUuid(string $uuid, array $data);

    public function delete($id);

    public function getRelatedPosts($args = []);

    public function getFeaturedPosts($args = []);
}
