<?php

declare(strict_types=1);

namespace App\Repositories\Contracts\Classified;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use App\Models\Classified\ClassifiedCategory;
use Illuminate\Database\Eloquent\Collection;

interface ClassifiedCategoryRepositoryInterface
{
    public function getAll(array $args = []);
    
    public function getParentCategories(): Collection;

    public function find(int $id): ?Model;

    public function findBySlug(string $slug): ?ClassifiedCategory;

    public function getChildCategories(int $parentId): Collection;

    public function create(array $data): Model;

    public function update(int $id, array $data): bool;

    public function delete(int $id): bool;
}
