<?php

namespace App\Repositories\Contracts\Classified;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Builder;

interface ClassifiedDeliveryRepositoryInterface 
{
    public function getAll(array $args = []): Builder;

    public function find(int $id): ?Model;
    
    public function findBySlug(string $slug): ?Model;

    public function findByUuid(string $uuid): ?Model;
    
    public function getByParentId(string $parentId): Collection;

    public function getChildDeliveries(string $parentId): Collection;
    
    public function create(array $data): Model;
    
    public function update(int $id, array $data): bool;
    
    public function updateByUuid(string $uuid, array $data): bool;
    
    public function delete(int $id): bool;

}