<?php

declare(strict_types=1);

namespace App\Repositories\Contracts\Classified;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

interface ClassifiedTagRepositoryInterface
{
    public function getAll(array $args = []);
    
    public function find(int $id): ?Model;
    
    public function findBySlug(string $slug): ?Model;
    
    public function create(array $data): Model;
    
    public function update(int $id, array $data): bool;
    
    public function delete(int $id): bool;
} 