<?php

namespace App\Repositories\Contracts\Inquiry;

use Illuminate\Database\Eloquent\Model;

interface InquiryRepositoryInterface
{
    public function getAll(array $args = []);

    public function findById(int $id): ?Model;

    public function findByUuid(string $uuid): ?Model;

    public function create(array $data): Model;

    public function update(Model $model, array $data): bool;

    public function delete(Model $model): bool;

}