<?php

namespace App\Repositories\Contracts\Job;

interface JobApplicationRepositoryInterface
{
    public function getAll($args = []);

    public function find($id);

    public function findByUuid(string $uuid);

    public function create(array $data);

    public function update($id, array $data);

    public function updateByUuid(string $uuid, array $data);

    public function delete($id);

    public function getApplicationsByJob($jobId);

    public function getApplicationsByApplicant($applicantId);

    public function getApplicationsByStatus($status);

    public function updateStatus($id, $status);
} 