<?php

namespace App\Repositories\Contracts\Job;

interface JobRepositoryInterface
{
    public function getAll($args = []);

    public function find($id);

    public function findBySlug($slug);

    public function findByUuid(string $uuid);

    public function create(array $data);

    public function update($id, array $data);

    public function updateByUuid(string $uuid, array $data);

    public function delete($id);

    public function getFeaturedJobs($args = []);

    public function getRelatedJobs($args = []);
} 