<?php

namespace App\Repositories\Contracts\Lead;

use App\Models\Lead\LeadForm;
use Illuminate\Database\Eloquent\Collection;

interface LeadFormFieldRepositoryInterface
{
    public function getFormFields(LeadForm $leadForm): Collection;

    public function attachField(LeadForm $leadForm, int $fieldId, array $pivotData): void;

    public function updateFieldPivot(LeadForm $leadForm, int $fieldId, array $pivotData): void;

    public function detachField(LeadForm $leadForm, int $fieldId): int;
}
