<?php

namespace App\Repositories\Contracts\Lead;

use App\Models\Lead\LeadForm;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface LeadFormRepositoryInterface
{
    public function getAll(array $filters = [], array $with = [], array $withCount = []): LengthAwarePaginator;

    public function findByUuid(string $uuid, array $with = [], array $withCount = []): ?LeadForm;

    public function findByUuidOrFail(string $uuid, array $with = [], array $withCount = []): LeadForm;

    public function findActiveByUuid(string $uuid, array $with = []): ?LeadForm;

    public function findActiveByUuidOrFail(string $uuid, array $with = []): LeadForm;

    public function create(array $data): LeadForm;

    public function update(LeadForm $leadForm, array $data): LeadForm;

    public function delete(LeadForm $leadForm): bool;

    public function syncFields(LeadForm $leadForm, array $fieldData): void;

    public function syncMemberCategories(LeadForm $leadForm, array $categoryData): void;

    public function attachFields(LeadForm $leadForm, array $fieldData): void;

    public function attachMemberCategories(LeadForm $leadForm, array $categoryData): void;
}
