<?php

namespace App\Repositories\Contracts\Lead;

use App\Models\Lead\LeadForm;
use App\Models\Lead\LeadFormVisit;

interface LeadFormVisitRepositoryInterface
{
    public function create(LeadForm $leadForm, array $data): LeadFormVisit;

    public function findByUuid(string $uuid): ?LeadFormVisit;

    public function findByUuidOrFail(string $uuid, array $with = []): LeadFormVisit;

    public function update(LeadFormVisit $visit, array $data): LeadFormVisit;

    public function delete(LeadFormVisit $visit): bool;
}
