<?php

namespace App\Repositories\Contracts\Lead;

use App\Models\Lead\Lead;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface LeadRepositoryInterface
{
    public function getAll(array $filters = [], array $with = []): LengthAwarePaginator;

    public function findById(int $id): ?Lead;

    public function findByUuid(string $uuid, array $with = []): ?Lead;

    public function findByUuidOrFail(string $uuid, array $with = []): Lead;

    public function create(array $data): Lead;

    public function update(Lead $lead, array $data): Lead;

    public function delete(Lead $lead): bool;

    public function attachUsers(Lead $lead, array $pivotData): void;

    public function syncUsers(Lead $lead, array $pivotData): void;

    public function updateUserPivot(Lead $lead, int $userId, array $data): void;

    public function setMeta(Lead $lead, string $key, $value): void;

    public function setAllMeta(Lead $lead, array $meta): void;
}
