<?php

namespace App\Repositories\Contracts\Location;

use Illuminate\Database\Eloquent\Model;

interface CityRepositoryInterface
{
    public function getAll(array $args = []);
    public function find($id);
    public function findBySlug(string $slug);
    public function findByUuid(string $uuid);
    public function create(array $data);
    public function update($id, array $data);
    public function delete($id);

    /**
     * Find a city by country ID and city name
     *
     * @param int $countryId
     * @param string $cityName
     * @return Model|null
     */
    public function findByCountryAndName(int $countryId, string $cityName): ?Model;

    public function findOrCreateByNameAndState(string $name, int $stateId, int $countryId);
}
