<?php

namespace App\Repositories\Contracts\Location;

interface CountryRepositoryInterface
{
    public function getAll(array $args = []);

    public function find($id);

    public function findBySlug(string $slug);

    public function findByUuid(string $uuid);

    public function create(array $data);

    public function update($id, array $data);

    public function updateByUuid(string $uuid, array $data);

    public function delete($id);

    public function findOrCreateByCodeAndName(string $code, string $name);
}
