<?php

namespace App\Repositories\Contracts\Location;

interface StateRepositoryInterface
{
    public function getAll(array $args = []);
    public function find($id);
    public function findBySlug(string $slug);
    public function findByUuid(string $uuid);
    public function create(array $data);
    public function update($id, array $data);
    public function delete($id);

    public function findOrCreateByNameAndCountry(string $name, int $countryId, ?string $code = null);
}