<?php

declare(strict_types=1);

namespace App\Repositories\Contracts\Payment;

use App\Models\User\User;
use App\Models\Membership\Payment;
use App\Models\Membership\Purchase;

interface PaymentRepositoryInterface
{
    /**
     * Create a payment record
     */
    public function createPayment(
        User $user,
        Purchase $purchase,
        string $paymentMethod,
        float $amount,
        string $currency,
        array $metadata = []
    ): Payment;

    /**
     * Update payment status
     */
    public function updatePaymentStatus(Payment $payment, string $status, array $metadata = []): bool;

    /**
     * Find payment by transaction ID
     */
    public function findByTransactionId(string $transactionId): ?Payment;
}
