<?php

declare(strict_types=1);

namespace App\Repositories\Contracts\Project;

interface ProjectRepositoryInterface
{
    public function getAll(array $args = []);

    public function find($id);

    public function findBySlug(string $slug);

    public function findByUuid(string $uuid);

    public function create(array $data);

    public function update($id, array $data);

    public function updateByUuid(string $uuid, array $data);

    public function delete($id);

    public function getRelatedProjects(array $args = []);

    public function getFeaturedProjects(array $args = []);

    public function getRelatedProjectsByProjectId(int $projectId);
}
