<?php

declare(strict_types=1);

namespace App\Repositories\Contracts\Purchase;

use App\Models\User\User;
use App\Models\Membership\Purchase;
use Illuminate\Database\Eloquent\Model;

interface PurchaseRepositoryInterface
{
    /**
     * Create a credit purchase record
     */
    public function createCreditPurchase(
        User $user,
        int $quantity,
        float $basePrice,
        float $amount,
        float $discountAmount,
        string $currency
    ): Purchase;

    /**
     * Update purchase purchaseable_id
     */
    public function updatePurchaseableId(Purchase $purchase, int $purchaseableId): bool;

    /**
     * Get all purchases with optional filters
     */
    public function getAll(array $args = []);

    /**
     * Find purchase by ID
     */
    public function findById(int $id): ?Model;

    /**
     * Find purchase by UUID
     */
    public function findByUuid(string $uuid): ?Model;

    /**
     * Create a new purchase record
     */
    public function create(array $data): Model;

    /**
     * Update an existing purchase record
     */
    public function update(Model $model, array $data): bool;

    /**
     * Delete a purchase record
     */
    public function delete(Model $model): bool;

    /**
     * Delete purchase by ID
     */
    public function deleteById(int $id): bool;

    /**
     * Delete purchase by UUID
     */
    public function deleteByUuid(string $uuid): bool;
}
