<?php

declare(strict_types=1);

namespace App\Repositories\Contracts\Review;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

interface ReviewRepositoryInterface
{
    public function getAll(array $args = []): Builder;

    public function find(int $id): ?Model;

    public function findByUuid(string $uuid): ?Model;

    public function create(array $data): Model;

    public function update(int $id, array $data): bool;

    public function updateByUuid(string $uuid, array $data): bool;

    public function delete(int $id): bool;

    public function getReviewsByReviewable(string $type, int $id, array $args = []): Builder;
}
