<?php

declare(strict_types=1);

namespace App\Repositories\Contracts\User;

use App\Models\User\MemberCategory;
use Illuminate\Database\Eloquent\Collection;

interface MemberCategoryRepositoryInterface
{
    public function getAll(array $args = []);
    
    public function getParentCategories(): Collection;

    public function findById(string $id): ?MemberCategory;

    public function getCategoryBySlug(string $slug): ?MemberCategory;

    public function getChildCategories(string $parentId): Collection;

    public function create(array $data): MemberCategory;

    public function update(string $id, array $data): bool;

    public function delete(string $id): bool;
} 