<?php

namespace App\Repositories\Contracts\User;
use App\Models\Membership\MembershipPlan;

interface MemberPlanRepositoryInterface
{
    public function getAll($array = []);

    public function findById(string $id): ?MembershipPlan;
    
    public function create(array $array): MembershipPlan;
    
    public function update(array $array, $id): bool;
    
    public function delete(string $id): bool;
    
    public function findByUuid(string $uuid): ?MembershipPlan;

    public function findBySlug(string $slug): ?MembershipPlan;

    public function findByMembershipType(string $membershipType): ?MembershipPlan;
}
