<?php

declare(strict_types=1);

namespace App\Repositories\Contracts\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Pagination\LengthAwarePaginator;

interface UserFavoriteRepositoryInterface
{
    public function getAll(array $args = []): Builder;

    public function find(int $id): ?Model;

    public function create(array $data): Model;

    public function delete(int $id): bool;

    public function getUserFavorites(int $userId, string $modelType = null): Builder;

    public function getUserFavoritesPaginated(int $userId, string $modelType = null, int $perPage = 15): LengthAwarePaginator;

    public function removeFavorite(int $userId, string $modelType, int $modelId): bool;

    public function isFavorite(int $userId, string $modelType, int $modelId): bool;
}