<?php

declare(strict_types=1);

namespace App\Repositories\Contracts\User;

use App\Models\User\UserLocation;
use Illuminate\Database\Eloquent\Collection;

interface UserLocationRepositoryInterface
{
    public function all(): Collection;
    public function findById(string $id): ?UserLocation;
    public function findByUuid(string $uuid): ?UserLocation;
    public function create(array $data): UserLocation;
    public function update(UserLocation $userLocation, array $data): bool;
    public function delete(UserLocation $userLocation): bool;
    public function getPrimaryLocation(int|string $userId): ?UserLocation;
    public function getActiveLocations(int|string $userId): Collection;
} 