<?php

namespace App\Repositories\Contracts\User;

use App\Models\Membership\Subscription;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

interface UserSubscriptionRepositoryInterface
{
    public function getAll(array $args = []): Builder;

    public function find(int $id): ?Model;

    public function findByUuid(string $uuid): ?Model;

    public function findBySlug(string $slug): ?Model;

    public function create(array $data): Model;

    public function update(int $id, array $data): bool;

    public function updateByUuid(string $uuid, array $data): bool;

    public function delete(int $id): bool;

    public function getByUserId(int $userId): ?Model;
        
}
