<?php

declare(strict_types=1);

namespace App\Repositories\Contracts\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

interface UserVideoRepositoryInterface
{
    public function getAll(array $args = []): Builder;

    public function find(int $id): ?Model;

    public function findByUuid(string $uuid): ?Model;

    public function findByUserId(int $userId, array $args = []): Builder;

    public function create(array $data): Model;

    public function update(int $id, array $data): bool;

    public function delete(int $id): bool;
} 